/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.executor.standalone;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.common.CountDownLatch2;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServiceThread
implements Runnable {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final long JOIN_TIME = 90000L;
    protected final Thread thread;
    protected final CountDownLatch2 waitPoint = new CountDownLatch2(1);
    private final Object startupShutdownMonitor = new Object();
    protected volatile AtomicBoolean hasNotified = new AtomicBoolean(false);
    protected volatile boolean stopped = true;
    protected volatile boolean active;
    protected volatile long defer = 60000L;

    public ServiceThread(String serviceName) {
        this.thread = new Thread((Runnable)this, serviceName);
        this.thread.setDaemon(true);
    }

    public abstract String getServiceName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int defer) {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (!this.active && this.stopped) {
                this.stopped = false;
                this.active = true;
                this.defer = defer;
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (!this.active && this.stopped) {
                this.stopped = false;
                this.active = true;
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (this.active && !this.stopped) {
                this.active = false;
                this.shutdown(false);
            }
        }
    }

    public void shutdown(boolean interrupt) {
        this.stopped = true;
        LOGGER.info("shutdown thread " + this.getServiceName() + " interrupt " + interrupt);
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
        try {
            if (interrupt) {
                this.thread.interrupt();
            }
            long beginTime = System.currentTimeMillis();
            if (!this.thread.isDaemon()) {
                this.thread.join(this.getJointime());
            }
            long eclipseTime = System.currentTimeMillis() - beginTime;
            LOGGER.info("join thread " + this.getServiceName() + " eclipse time(ms) " + eclipseTime + " " + this.getJointime());
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Interrupted", (Throwable)e);
        }
    }

    public long getJointime() {
        return 90000L;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean interrupt) {
        this.stopped = true;
        this.active = false;
        LOGGER.info("stop thread " + this.getServiceName() + " interrupt " + interrupt);
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
        if (interrupt) {
            this.thread.interrupt();
        }
    }

    public void makeStop() {
        this.stopped = true;
        LOGGER.info("makestop thread " + this.getServiceName());
    }

    public void wakeup() {
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
    }

    public void restart(int defer) {
        this.stop(false);
        this.defer = defer;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        if (this.hasNotified.compareAndSet(true, false)) {
            this.onWaitEnd();
            return;
        }
        this.waitPoint.reset();
        try {
            this.waitPoint.await(interval, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Interrupted", (Throwable)e);
        }
        finally {
            this.hasNotified.set(false);
            this.onWaitEnd();
        }
    }

    protected abstract void onWaitEnd();

    public boolean isStopped() {
        return this.stopped;
    }
}

