/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.producer;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaProducerCollector;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerConfig;

public class KafkaProducerInterceptor
implements Interceptor {
    private boolean isInited = false;
    private ThreadLocal<Boolean> context = new ThreadLocal();

    private String getClientId(Object object) {
        Object[] fileds;
        if (object instanceof AttributeAccess && (fileds = ((AttributeAccess)object).getLopsFileds()).length > 0) {
            return (String)fileds[0];
        }
        return null;
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (!this.isInited) {
            CollectorManager.TAGS.add("KafkaProducer");
            KafkaProducerCollector.getInstance();
            this.isInited = true;
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (KafkaProducerCollector.INSTANCE.isEnable()) {
            Boolean bl = this.context.get();
            if (bl != null) {
                return;
            }
            KafkaProducerCollector.onError((Throwable)e);
            this.context.set(Boolean.TRUE);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        String clientId = this.getClientId(object);
        if (clientId != null && args.length > 0 && KafkaHelper.PRODUCERINFO.getIp(clientId) == null) {
            Map map = null;
            if (args[0] instanceof ProducerConfig) {
                map = ((ProducerConfig)args[0]).originals();
            } else if (args[0] instanceof Map) {
                map = (Map)args[0];
            }
            if (map != null) {
                Object ips = map.get("bootstrap.servers");
                KafkaHelper.PRODUCERINFO.addIp(clientId, ips != null ? ips.toString() : "unknow");
            }
        }
        this.context.remove();
    }
}

