/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql8.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql8.interceptor.PreparedStatementInteceptor;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import java.sql.SQLException;

public class PreparedStatementExecuteQueryInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)this.getOriginSql(preparedStatement), (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    private String getOriginSql(ClientPreparedStatement mysql8PreparedStatement) throws SQLException {
        try {
            return mysql8PreparedStatement.asSql();
        }
        catch (NoSuchMethodError e) {
            return ((PreparedQuery)mysql8PreparedStatement.getQuery()).asSql();
        }
    }

    public void onError(Object object, Object[] args, Throwable th, String className, String methodName) {
        try {
            ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
            String sql = preparedStatement.getPreparedSql();
            PreparedStatementInteceptor.onError(sql, th);
            MysqlTrace.onError((Throwable)th);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                ResultSetImpl mysql8ResultSet = (ResultSetImpl)result;
                int mysql8ReadRowCount = 0;
                if (mysql8ResultSet != null && (mysql8ReadRowCount = Integer.valueOf(String.valueOf(mysql8ResultSet.getUpdateCount())).intValue()) == -1) {
                    mysql8ReadRowCount = 1;
                }
                MysqlCollector.onFinally((int)0, (int)mysql8ReadRowCount);
                if (result != null && result instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)0, (int)mysql8ReadRowCount, (TransformAccess)((TransformAccess)result));
                } else {
                    MysqlTrace.onFinally((int)0, (int)mysql8ReadRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)0, (int)mysql8ReadRowCount);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

