/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.c3p0.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class C3P0DataSourceAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final String C3P0_DATA_SOURCE_OBJECT_NAME = "com.mchange.v2.c3p0:type=PooledDataSource,*";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> res = new ArrayList<MonitorDataRow>();
        try {
            Set<ObjectName> c3p0DataSourceMBeans = this.server.queryNames(new ObjectName(C3P0_DATA_SOURCE_OBJECT_NAME), null);
            if (c3p0DataSourceMBeans == null || c3p0DataSourceMBeans.isEmpty()) {
                return res;
            }
            for (ObjectName c3p0DataSourceMBean : c3p0DataSourceMBeans) {
                MonitorDataRow row = new MonitorDataRow();
                row.put((Object)"driverClass", this.server.getAttribute(c3p0DataSourceMBean, "driverClass"));
                row.put((Object)"url", this.server.getAttribute(c3p0DataSourceMBean, "jdbcUrl"));
                row.put((Object)"initialPoolSize", this.server.getAttribute(c3p0DataSourceMBean, "initialPoolSize"));
                row.put((Object)"minPoolSize", this.server.getAttribute(c3p0DataSourceMBean, "minPoolSize"));
                row.put((Object)"maxPoolSize", this.server.getAttribute(c3p0DataSourceMBean, "maxPoolSize"));
                row.put((Object)"numConnections", this.server.getAttribute(c3p0DataSourceMBean, "numConnections"));
                row.put((Object)"numBusyConnections", this.server.getAttribute(c3p0DataSourceMBean, "numBusyConnections"));
                row.put((Object)"numIdleConnections", this.server.getAttribute(c3p0DataSourceMBean, "numIdleConnections"));
                row.put((Object)"maxIdleTime", this.server.getAttribute(c3p0DataSourceMBean, "maxIdleTime"));
                row.put((Object)"idleConnectionTestPeriod", this.server.getAttribute(c3p0DataSourceMBean, "idleConnectionTestPeriod"));
                row.put((Object)"testConnectionOnCheckout", (Object)String.valueOf(this.server.getAttribute(c3p0DataSourceMBean, "testConnectionOnCheckout")));
                row.put((Object)"testConnectionOnCheckin", (Object)String.valueOf(this.server.getAttribute(c3p0DataSourceMBean, "testConnectionOnCheckin")));
                row.put((Object)"acquireRetryAttempts", this.server.getAttribute(c3p0DataSourceMBean, "acquireRetryAttempts"));
                row.put((Object)"acquireRetryDelay", this.server.getAttribute(c3p0DataSourceMBean, "acquireRetryDelay"));
                row.put((Object)"acquireIncrement", this.server.getAttribute(c3p0DataSourceMBean, "acquireIncrement"));
                res.add(row);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "C3P0 harvest: collector monitor data error", (Throwable)e);
        }
        return res;
    }

    public String getName() {
        return "dataSource";
    }
}

