/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.plugin.rabbitmq.producer.collector.RabbitMqConnectionPublishInvokeAggregator;
import com.lubanops.apm.plugin.rabbitmq.producer.collector.RabbitMqExchangePublishAggregator;
import com.rabbitmq.client.impl.AMQConnection;
import java.util.List;
import java.util.Map;

public class RabbitMqProducerCollector
extends Collector {
    public static volatile boolean isInited = false;
    public static final RabbitMqProducerCollector INSTANCE = new RabbitMqProducerCollector();
    public static final RabbitMqExchangePublishAggregator EXCHANGE_AGGREGATOR = new RabbitMqExchangePublishAggregator();
    public static final RabbitMqConnectionPublishInvokeAggregator CONNECTION_PUBLISH_AGGREGATOR = new RabbitMqConnectionPublishInvokeAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();

    public static void onPublishStart(AMQConnection connection, String exchange) {
        EXCHANGE_AGGREGATOR.onStart(connection.toString(), exchange);
        CONNECTION_PUBLISH_AGGREGATOR.onStart(connection);
    }

    public static void onPublishFinally(int bytesCount, boolean hasError) {
        if (!hasError) {
            EXCHANGE_AGGREGATOR.incrementPublishedMsgCount();
            EXCHANGE_AGGREGATOR.incrementPublishedBytesCount(bytesCount);
            EXCHANGE_AGGREGATOR.setMaxSingleMsgBytes(bytesCount);
            CONNECTION_PUBLISH_AGGREGATOR.incrementPublishedMsgCount();
            CONNECTION_PUBLISH_AGGREGATOR.incrementPublishedBytesCount(bytesCount);
            CONNECTION_PUBLISH_AGGREGATOR.setMaxSingleMsgBytes(bytesCount);
        }
        EXCHANGE_AGGREGATOR.onFinally();
        CONNECTION_PUBLISH_AGGREGATOR.onFinally();
    }

    public static void onError(String errorTraceId) {
        EXCHANGE_AGGREGATOR.onError(errorTraceId);
        CONNECTION_PUBLISH_AGGREGATOR.onError(errorTraceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTag() {
        if (!isInited) {
            List list = CollectorManager.TAGS;
            synchronized (list) {
                if (!isInited) {
                    CollectorManager.addTag((String)"RabbitMqProducer");
                    isInited = true;
                }
            }
        }
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "RabbitMqProducer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCHANGE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CONNECTION_PUBLISH_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

