/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqConnectionCountAggregator;
import java.util.Map;

public class RabbitMqCommonCollector
extends Collector {
    public static final RabbitMqCommonCollector INSTANCE = new RabbitMqCommonCollector();
    public static final RabbitMqConnectionCountAggregator CONNECTION_COUNT_AGGREGATOR = new RabbitMqConnectionCountAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void onConnectionCreation(String connection) {
        CONNECTION_COUNT_AGGREGATOR.incrementConnectionCreatedCount(connection, 1);
    }

    public static void onConnectionCreation(String connection, int count) {
        CONNECTION_COUNT_AGGREGATOR.incrementConnectionCreatedCount(connection, count);
    }

    public static void onConnectionClose(String connection) {
        CONNECTION_COUNT_AGGREGATOR.incrementConnectionClosedCount(connection, 1);
    }

    public static void onConnectionClose(String connection, int count) {
        CONNECTION_COUNT_AGGREGATOR.incrementConnectionClosedCount(connection, count);
    }

    public static void onChannelCreation(String connection) {
        CONNECTION_COUNT_AGGREGATOR.incrementChannelCreatedCount(connection, 1);
    }

    public static void onChannelCreation(String connection, int count) {
        CONNECTION_COUNT_AGGREGATOR.incrementChannelCreatedCount(connection, count);
    }

    public static void onChannelClose(String connection) {
        CONNECTION_COUNT_AGGREGATOR.incrementChannelClosedCount(connection, 1);
    }

    public static void onChannelClose(String connection, int count) {
        CONNECTION_COUNT_AGGREGATOR.incrementChannelClosedCount(connection, count);
    }

    public static void setDriverVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "RabbitMqCommon";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CONNECTION_COUNT_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

