/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.lettuce.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.plugin.redis.collector.ClientInfoAggregator;
import com.lubanops.apm.plugin.redis.collector.MasterSwitchAggregator;
import com.lubanops.apm.plugin.redis.collector.commons.RedisModeEnum;
import java.util.List;
import java.util.Map;

public class LettuceCollector
extends Collector {
    private static final LettuceCollector INSTANCE = new LettuceCollector();
    private static final MasterSwitchAggregator MASTER_SWITCH_AGGREGATOR = new MasterSwitchAggregator();
    private static final ClientInfoAggregator JEDIS_INFO_AGGREGATOR = new ClientInfoAggregator();

    public static LettuceCollector getInstance() {
        return INSTANCE;
    }

    public static void setJedisVersion(String s) {
        JEDIS_INFO_AGGREGATOR.setClientVersion(s);
    }

    public LettuceCollector mode(String mode) {
        JEDIS_INFO_AGGREGATOR.setMode(RedisModeEnum.getEnvByCode(mode));
        return this;
    }

    public void onClusterSwitch(List<String> to) {
        if (to != null && !to.isEmpty()) {
            MASTER_SWITCH_AGGREGATOR.clusterSwitch(to);
            JEDIS_INFO_AGGREGATOR.setClusterNodes(to);
        }
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "Lettuce";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)MASTER_SWITCH_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JEDIS_INFO_AGGREGATOR);
        INSTANCE.register();
    }
}

