/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.paho.mqttv3.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mqtt.MqttContext;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.PahoPublisherCollector;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.PahoSubscriberCollector;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.paho.mqttv3.PahoMqttV3Utils;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsInternalSendInterceptor
implements Interceptor {
    public CommsInternalSendInterceptor() {
        PahoPublisherCollector.setVersion((String)Util.getJarVersionFromProtectionDomain((ProtectionDomain)MqttClient.class.getProtectionDomain()));
        PahoSubscriberCollector.setVersion((String)Util.getJarVersionFromProtectionDomain((ProtectionDomain)MqttClient.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (PahoPublisherCollector.INSTANCE.isEnable()) {
                ClientComms clientComms = (ClientComms)object;
                MqttWireMessage msg = (MqttWireMessage)args[0];
                String serverUri = clientComms.getClient().getServerURI();
                String type = MqttContext.getMessageType((int)msg.getType());
                String clientId = clientComms.getClient().getClientId();
                int msgId = msg.getMessageId();
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"PahoPublisher");
                Map<String, Object> map = null;
                if (spanEvent != null) {
                    spanEvent.addTag("Server Uri", serverUri);
                    spanEvent.addTag("Message Type", type);
                    spanEvent.addTag("Client Id", clientId);
                    spanEvent.addTag("Message Id", String.valueOf(msgId));
                    if (msg instanceof MqttPublish) {
                        PahoMqttV3Utils.addTag(spanEvent, (MqttPublish)msg);
                    }
                }
                if (msg instanceof MqttPublish) {
                    map = PahoPublisherCollector.onSendStartAsync((String)(serverUri + "@" + ((MqttPublish)msg).getTopicName()));
                }
                if (map == null) {
                    map = new HashMap<String, SpanEvent>();
                }
                map.put("spanEvent", spanEvent);
                ((TransformAccess)msg).setLopsAttribute(map);
            }
        }
        catch (Exception internalSendException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)internalSendException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            MqttWireMessage msg;
            if (PahoPublisherCollector.INSTANCE.isEnable() && (msg = (MqttWireMessage)args[0]) instanceof MqttPublish) {
                Map map = (Map)((TransformAccess)args[0]).getLopsAttribute();
                SpanEvent spanEvent = (SpanEvent)map.get("spanEvent");
                TraceCollector.onError((SpanEvent)spanEvent, (Throwable)e);
                PahoPublisherCollector.onSendErrorAsync((Map)map);
                PahoPublisherCollector.onException((Throwable)e);
            }
        }
        catch (Exception internalSendException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)internalSendException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            MqttWireMessage msg;
            if (PahoPublisherCollector.INSTANCE.isEnable() && (msg = (MqttWireMessage)args[0]) instanceof MqttPublish) {
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Exception internalSendException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)internalSendException);
        }
    }
}

