/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.moquette.broker.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.moquette.broker.collector.MoquetteBrokerCollector;
import com.lubanops.apm.plugin.moquette.broker.collector.MoquetteBrokerSampleFilter;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttConnectMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttDisconnectMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPingReqMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPubAckMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPubCompMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPubRecMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPubRelMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttPublishMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttSubscribeMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttUnsubscribeMessageProcessor;
import com.lubanops.apm.plugin.moquette.broker.processors.UnknownMqttMessageProcessor;
import io.moquette.broker.Server;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public class NettyMQTTHandlerChannelReadInterceptor
implements Interceptor {
    private final Map<MqttMessageType, MqttMessageProcessor> messageProcessors = new HashMap<MqttMessageType, MqttMessageProcessor>();
    private final MqttMessageProcessor defaultProcessor = new UnknownMqttMessageProcessor();
    private final ThreadLocal<Boolean> reportSpanLocal = new ThreadLocal();

    public NettyMQTTHandlerChannelReadInterceptor() {
        Class<Object> serverClass;
        try {
            serverClass = Class.forName("io.moquette.server.Server");
        }
        catch (ClassNotFoundException notFoundException) {
            serverClass = Server.class;
        }
        MoquetteBrokerCollector.setVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)serverClass.getProtectionDomain()));
        this.messageProcessors.put(MqttMessageType.CONNECT, new MqttConnectMessageProcessor());
        this.messageProcessors.put(MqttMessageType.SUBSCRIBE, new MqttSubscribeMessageProcessor());
        this.messageProcessors.put(MqttMessageType.UNSUBSCRIBE, new MqttUnsubscribeMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PUBLISH, new MqttPublishMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PUBREC, new MqttPubRecMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PUBCOMP, new MqttPubCompMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PUBREL, new MqttPubRelMessageProcessor());
        this.messageProcessors.put(MqttMessageType.DISCONNECT, new MqttDisconnectMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PUBACK, new MqttPubAckMessageProcessor());
        this.messageProcessors.put(MqttMessageType.PINGREQ, new MqttPingReqMessageProcessor());
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MoquetteBrokerCollector.INSTANCE.isEnable() && args[1] instanceof MqttMessage) {
                ChannelHandlerContext ctx = (ChannelHandlerContext)args[0];
                MqttMessage msg = (MqttMessage)args[1];
                MqttMessageType messageType = msg.fixedHeader() == null || msg.fixedHeader().messageType() == null ? null : msg.fixedHeader().messageType();
                if (msg instanceof MqttPublishMessage) {
                    MqttPublishMessage publishMsg = (MqttPublishMessage)msg;
                    String topic = ((MqttPublishMessage)msg).variableHeader().topicName();
                    MoquetteBrokerCollector.onReceivePublishMsg(topic, publishMsg.payload().capacity());
                }
                Map<String, String> traceInfo = NettyMQTTHandlerChannelReadInterceptor.getTraceInfo(msg);
                String source = ctx.channel().localAddress().toString();
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceInfo.get("lb_tra"), traceInfo.get("lb_spa"), traceInfo.get("lb_gtr"));
                startTraceRequest.setKind("MoquetteBroker");
                startTraceRequest.setSourceEventId(traceInfo.get("lb_sou"));
                startTraceRequest.setDomainId(traceInfo.get("lb_dom"));
                startTraceRequest.setSource(source);
                startTraceRequest.setRealSource(source);
                startTraceRequest.setMethod(methodName);
                startTraceRequest.setSampleFilter((SampleFilter)new MoquetteBrokerSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(traceInfo.get("lb_uf"));
                MqttMessageProcessor processor = this.messageProcessors.get(messageType);
                if (processor == null) {
                    processor = this.defaultProcessor;
                }
                this.reportSpanLocal.set(processor.process(ctx, msg, spanEvent));
            }
        }
        catch (Exception channelReadException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)channelReadException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MoquetteBrokerCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (spanEvent != null) {
                    TraceCollector.onError((Throwable)e);
                }
                MoquetteBrokerCollector.onException(e);
            }
        }
        catch (Exception channelReadException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)channelReadException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            SpanEvent spanEvent;
            if (MoquetteBrokerCollector.INSTANCE.isEnable() && args[1] instanceof MqttMessage && (spanEvent = TraceCollector.getSpanEvent()) != null) {
                boolean hasError = spanEvent.getHasError();
                int code = hasError ? 500 : 200;
                Boolean reportSpan = this.reportSpanLocal.get();
                if (Boolean.TRUE.equals(reportSpan)) {
                    TraceCollector.onFinally((int)code, (boolean)hasError);
                } else {
                    TraceCollector.onFinally((boolean)false);
                }
            }
        }
        catch (Exception channelReadException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)channelReadException);
        }
    }

    private static Map<String, String> getTraceInfo(MqttMessage message) {
        HashMap<String, String> res = new HashMap<String, String>();
        String traceId = "";
        String spanId = "";
        String sourceEventId = "";
        String domainId = "";
        String gtraceId = "";
        String userFlag = "";
        res.put("lb_tra", traceId);
        res.put("lb_spa", spanId);
        res.put("lb_sou", sourceEventId);
        res.put("lb_dom", domainId);
        res.put("lb_gtr", gtraceId);
        res.put("lb_uf", userFlag);
        return res;
    }
}

