/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum2X4;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.FDBigInteger;
import com.alibaba.fastjson2.util.FloatingDecimal;
import com.alibaba.fastjson2.util.JSONObject1O;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public class TypeUtils {
    public static final Class CLASS_JSON_OBJECT_1x;
    public static final Field FIELD_JSON_OBJECT_1x_map;
    public static final Class CLASS_JSON_ARRAY_1x;
    public static final Class CLASS_SINGLE_SET;
    public static final Class CLASS_SINGLE_List;
    public static final Class CLASS_UNMODIFIABLE_COLLECTION;
    public static final Class CLASS_UNMODIFIABLE_LIST;
    public static final Class CLASS_UNMODIFIABLE_SET;
    public static final Class CLASS_UNMODIFIABLE_SORTED_SET;
    public static final Class CLASS_UNMODIFIABLE_NAVIGABLE_SET;
    public static final ParameterizedType PARAM_TYPE_LIST_STR;
    static final Cache CACHE;
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER;
    static final Map<Class, String> NAME_MAPPINGS;
    static final Map<String, Class> TYPE_MAPPINGS;

    public static Type intern(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] actualTypeArguments = paramType.getActualTypeArguments();
            if (rawType == List.class && actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class) {
                return PARAM_TYPE_LIST_STR;
            }
        }
        return type;
    }

    public static double parseDouble(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return TypeUtils.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double parseDouble(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return TypeUtils.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float parseFloat(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return TypeUtils.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float parseFloat(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return TypeUtils.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double doubleValue(boolean isNegative, int decExp, char[] digits, int nDigits) {
        boolean overvalue;
        double t;
        int j;
        int kDigits = Math.min(nDigits, 16);
        int iValue = digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (int i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        long lValue = iValue;
        for (int i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(digits[i] - 48);
        }
        double dValue = lValue;
        int exp = decExp - kDigits;
        if (nDigits <= 15) {
            if (exp == 0 || dValue == 0.0) {
                return isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= FloatingDecimal.MAX_SMALL_TEN) {
                    double rValue = dValue * FloatingDecimal.SMALL_10_POW[exp];
                    return isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= FloatingDecimal.MAX_SMALL_TEN + slop) {
                    double rValue = (dValue *= FloatingDecimal.SMALL_10_POW[slop]) * FloatingDecimal.SMALL_10_POW[exp - slop];
                    return isNegative ? -rValue : rValue;
                }
            } else if (exp >= -FloatingDecimal.MAX_SMALL_TEN) {
                double rValue = dValue / FloatingDecimal.SMALL_10_POW[-exp];
                return isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (decExp > 309) {
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= FloatingDecimal.SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= FloatingDecimal.BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * FloatingDecimal.BIG_10_POW[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= FloatingDecimal.BIG_10_POW[j])) {
                        return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExp < -325) {
                return isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= FloatingDecimal.SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= FloatingDecimal.TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * FloatingDecimal.TINY_10_POW[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= FloatingDecimal.TINY_10_POW[j]) == 0.0) {
                        return isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        if (nDigits > 1100) {
            nDigits = 1101;
            digits[1100] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(lValue, digits, kDigits, nDigits);
        exp = decExp - nDigits;
        long ieeeBits = Double.doubleToRawLongBits(dValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            int cmpResult;
            int binexp = (int)(ieeeBits >>> 52);
            long bigBbits = ieeeBits & 0xFFFFFFFFFFFFFL;
            if (binexp > 0) {
                bigBbits |= 0x10000000000000L;
            } else {
                assert (bigBbits != 0L) : bigBbits;
                int leadingZeros = Long.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 11;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Long.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 1023) - 52 + lowOrderZeros;
            int bigIntNBits = 53 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -1023 ? binexp + lowOrderZeros + 1023 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -1022 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult != 0) continue;
            if ((ieeeBits & 1L) == 0L) break;
            ieeeBits += overvalue ? -1L : 1L;
            break;
        } while ((ieeeBits += overvalue ? -1L : 1L) != 0L && ieeeBits != 0x7FF0000000000000L);
        if (isNegative) {
            ieeeBits |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(ieeeBits);
    }

    public static float floatValue(boolean isNegative, int decExponent, char[] digits, int nDigits) {
        boolean overvalue;
        int j;
        int kDigits = Math.min(nDigits, 8);
        int iValue = digits[0] - 48;
        for (int i = 1; i < kDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        float fValue = iValue;
        int exp = decExponent - kDigits;
        if (nDigits <= 7) {
            if (exp == 0 || fValue == 0.0f) {
                return isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= FloatingDecimal.SINGLE_MAX_SMALL_TEN) {
                    return isNegative ? -fValue : (fValue *= FloatingDecimal.SINGLE_SMALL_10_POW[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= FloatingDecimal.SINGLE_MAX_SMALL_TEN + slop) {
                    fValue *= FloatingDecimal.SINGLE_SMALL_10_POW[slop];
                    return isNegative ? -fValue : (fValue *= FloatingDecimal.SINGLE_SMALL_10_POW[exp - slop]);
                }
            } else if (exp >= -FloatingDecimal.SINGLE_MAX_SMALL_TEN) {
                return isNegative ? -fValue : (fValue /= FloatingDecimal.SINGLE_SMALL_10_POW[-exp]);
            }
        } else if (decExponent >= nDigits && nDigits + decExponent <= 15) {
            long lValue = iValue;
            for (int i = kDigits; i < nDigits; ++i) {
                lValue = lValue * 10L + (long)(digits[i] - 48);
            }
            double dValue = lValue;
            exp = decExponent - nDigits;
            fValue = (float)(dValue *= FloatingDecimal.SMALL_10_POW[exp]);
            return isNegative ? -fValue : fValue;
        }
        double dValue = fValue;
        if (exp > 0) {
            if (decExponent > 39) {
                return isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= FloatingDecimal.SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= FloatingDecimal.BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExponent < -46) {
                return isNegative ? -0.0f : 0.0f;
            }
            if ((exp & 0xF) != 0) {
                dValue /= FloatingDecimal.SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= FloatingDecimal.TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        }
        fValue = Math.max(Float.MIN_VALUE, Math.min(Float.MAX_VALUE, (float)dValue));
        if (nDigits > 200) {
            nDigits = 201;
            digits[200] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(iValue, digits, kDigits, nDigits);
        exp = decExponent - nDigits;
        int ieeeBits = Float.floatToRawIntBits(fValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            int cmpResult;
            int binexp = ieeeBits >>> 23;
            int bigBbits = ieeeBits & 0x7FFFFF;
            if (binexp > 0) {
                bigBbits |= 0x800000;
            } else {
                assert (bigBbits != 0) : bigBbits;
                int leadingZeros = Integer.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 8;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Integer.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 127) - 23 + lowOrderZeros;
            int bigIntNBits = 24 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -127 ? binexp + lowOrderZeros + 127 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -126 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult != 0) continue;
            if ((ieeeBits & 1) == 0) break;
            ieeeBits += overvalue ? -1 : 1;
            break;
        } while ((ieeeBits += overvalue ? -1 : 1) != 0 && ieeeBits != 2139095040);
        if (isNegative) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(ieeeBits);
    }

    public static Class<?> getMapping(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getMapping(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getMapping(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getMapping(upperBounds[0]);
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypeUtils.getClass(genericComponentType);
            return TypeUtils.getArrayClass(componentClass);
        }
        return Object.class;
    }

    public static Date toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Instant) {
            Instant instant = (Instant)obj;
            return new Date(instant.toEpochMilli());
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDate) {
            LocalDate localDate = (LocalDate)obj;
            ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)obj;
            ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof String) {
            return DateUtils.parseDate((String)obj);
        }
        if (obj instanceof Long || obj instanceof Integer) {
            return new Date(((Number)obj).longValue());
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static Instant toInstant(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Instant) {
            return (Instant)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant();
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return zdt.toInstant();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            JSONReader jsonReader = str.charAt(0) != '\"' ? JSONReader.of('\"' + str + '\"') : JSONReader.of(str);
            return jsonReader.read(Instant.class);
        }
        if (obj instanceof Map) {
            return (Instant)ObjectReaderImplInstant.INSTANCE.createInstance((Map)obj, 0L);
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static Object[] cast(Object obj, Type[] types) {
        if (obj == null) {
            return null;
        }
        Object[] array = new Object[types.length];
        if (obj instanceof Collection) {
            int i = 0;
            for (Object item : (Collection)obj) {
                int index = i++;
                array[index] = TypeUtils.cast(item, types[index]);
            }
        } else {
            Class<?> objectClass = obj.getClass();
            if (objectClass.isArray()) {
                int length = Array.getLength(obj);
                for (int i = 0; i < array.length && i < length; ++i) {
                    Object item = Array.get(obj, i);
                    array[i] = TypeUtils.cast(item, types[i]);
                }
            } else {
                throw new JSONException("can not cast to types " + JSON.toJSONString(types) + " from " + objectClass);
            }
        }
        return array;
    }

    public static String[] toStringArray(Object object) {
        if (object == null || object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String[] array = new String[collection.size()];
            int i = 0;
            for (Object item : (Collection)object) {
                int index = i++;
                array[index] = item == null || item instanceof String ? (String)item : item.toString();
            }
            return array;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isArray()) {
            int length = Array.getLength(object);
            String[] array = new String[length];
            for (int i = 0; i < array.length; ++i) {
                Object item = Array.get(object, i);
                array[i] = item == null || item instanceof String ? (String)item : item.toString();
            }
            return array;
        }
        return TypeUtils.cast(object, String[].class);
    }

    public static <T> T cast(Object obj, Type type) {
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type);
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        if (obj instanceof Collection) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Collection)obj);
        }
        if (obj instanceof Map) {
            ObjectReader objectReader = provider.getObjectReader(type);
            return objectReader.createInstance((Map)obj, 0L);
        }
        String json = JSON.toJSONString(obj);
        return JSON.parseObject(json, type);
    }

    public static <T> T cast(Object obj, Class<T> targetClass) {
        return TypeUtils.cast(obj, targetClass, JSONFactory.getDefaultObjectReaderProvider());
    }

    public static <T> T cast(Object obj, Class<T> targetClass, ObjectReaderProvider provider) {
        if (obj == null) {
            return null;
        }
        if (targetClass.isInstance(obj)) {
            return (T)obj;
        }
        if (targetClass == Date.class) {
            return (T)TypeUtils.toDate(obj);
        }
        if (targetClass == Instant.class) {
            return (T)TypeUtils.toInstant(obj);
        }
        if (targetClass == String.class) {
            if (obj instanceof Character) {
                return (T)obj.toString();
            }
            return (T)JSON.toJSONString(obj);
        }
        if (targetClass == AtomicInteger.class) {
            return (T)new AtomicInteger(TypeUtils.toIntValue(obj));
        }
        if (targetClass == AtomicLong.class) {
            return (T)new AtomicLong(TypeUtils.toLongValue(obj));
        }
        if (targetClass == AtomicBoolean.class) {
            return (T)new AtomicBoolean((Boolean)obj);
        }
        if (obj instanceof Map) {
            ObjectReader objectReader = provider.getObjectReader(targetClass);
            return objectReader.createInstance((Map)obj, 0L);
        }
        Function typeConvert = provider.getTypeConvert(obj.getClass(), targetClass);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (obj instanceof String) {
            String json = (String)obj;
            if (json.isEmpty() || "null".equals(json)) {
                return null;
            }
            char first = json.trim().charAt(0);
            JSONReader jsonReader = first == '\"' || first == '{' || first == '[' ? JSONReader.of(json) : JSONReader.of(JSON.toJSONString(json));
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass);
            return objectReader.readObject(jsonReader, null, null, 0L);
        }
        if (targetClass.isEnum() && obj instanceof Integer) {
            int intValue = (Integer)obj;
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass);
            if (objectReader instanceof ObjectReaderImplEnum) {
                return (T)((ObjectReaderImplEnum)objectReader).of(intValue);
            }
            if (objectReader instanceof ObjectReaderImplEnum2X4) {
                return (T)((ObjectReaderImplEnum2X4)objectReader).getEnumByOrdinal(intValue);
            }
        }
        if (obj instanceof Collection) {
            ObjectReader objectReader = provider.getObjectReader(targetClass);
            return objectReader.createInstance((Collection)obj);
        }
        throw new JSONException("can not cast to " + targetClass.getName() + ", from " + obj.getClass());
    }

    public static String getTypeName(Class type) {
        String typeName;
        Class<?>[] interfaces;
        String mapTypeName = NAME_MAPPINGS.get(type);
        if (mapTypeName != null) {
            return mapTypeName;
        }
        if (Proxy.isProxyClass(type) && (interfaces = type.getInterfaces()).length > 0) {
            type = interfaces[0];
        }
        switch (typeName = type.getTypeName()) {
            case "com.alibaba.fastjson.JSONObject": {
                NAME_MAPPINGS.putIfAbsent(type, "JO1");
                return NAME_MAPPINGS.get(type);
            }
            case "com.alibaba.fastjson.JSONArray": {
                NAME_MAPPINGS.putIfAbsent(type, "JA1");
                return NAME_MAPPINGS.get(type);
            }
        }
        return typeName;
    }

    public static Class getMapping(String typeName) {
        return TYPE_MAPPINGS.get(typeName);
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null || value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigDecimal(str);
        }
        throw new JSONException("can not cast to decimal from " + value.getClass());
    }

    public static BigInteger toBigInteger(Object value) {
        if (value == null || value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("can not cast to bigint");
    }

    public static Long toLong(Object value) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long, class " + value.getClass());
    }

    public static long toLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long from " + value.getClass());
    }

    public static Boolean parseBoolean(byte[] bytes, int off, int len) {
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                byte b0 = bytes[off];
                if (b0 == 49 || b0 == 89) {
                    return Boolean.TRUE;
                }
                if (b0 != 48 && b0 != 78) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (bytes[off] != 116 || bytes[off + 1] != 114 || bytes[off + 2] != 117 || bytes[off + 3] != 101) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (bytes[off] != 102 || bytes[off + 1] != 97 || bytes[off + 2] != 108 || bytes[off + 3] != 115 || bytes[off + 4] != 101) break;
                return Boolean.FALSE;
            }
        }
        String str = new String(bytes, off, len);
        return Boolean.parseBoolean(str);
    }

    public static Integer parseInt(byte[] bytes, int off, int len) {
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                byte b0 = bytes[off];
                if (b0 < 48 || b0 > 57) break;
                return b0 - 48;
            }
            case 2: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57) break;
                return (b0 - 48) * 10 + (b1 - 48);
            }
            case 3: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57) break;
                return (b0 - 48) * 100 + (b1 - 48) * 10 + (b2 - 48);
            }
            case 4: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57) break;
                return (b0 - 48) * 1000 + (b1 - 48) * 100 + (b2 - 48) * 10 + (b3 - 48);
            }
            case 5: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57) break;
                return (b0 - 48) * 10000 + (b1 - 48) * 1000 + (b2 - 48) * 100 + (b3 - 48) * 10 + (b4 - 48);
            }
            case 6: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57) break;
                return (b0 - 48) * 100000 + (b1 - 48) * 10000 + (b2 - 48) * 1000 + (b3 - 48) * 100 + (b4 - 48) * 10 + (b5 - 48);
            }
            case 7: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57) break;
                return (b0 - 48) * 1000000 + (b1 - 48) * 100000 + (b2 - 48) * 10000 + (b3 - 48) * 1000 + (b4 - 48) * 100 + (b5 - 48) * 10 + (b6 - 48);
            }
            case 8: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                byte b7 = bytes[off + 7];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57 || b7 < 48 || b7 > 57) break;
                return (b0 - 48) * 10000000 + (b1 - 48) * 1000000 + (b2 - 48) * 100000 + (b3 - 48) * 10000 + (b4 - 48) * 1000 + (b5 - 48) * 100 + (b6 - 48) * 10 + (b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Integer.parseInt(str);
    }

    public static Long parseLong(byte[] bytes, int off, int len) {
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                byte b0 = bytes[off];
                if (b0 < 48 || b0 > 57) break;
                return b0 - 48;
            }
            case 2: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57) break;
                return (long)(b0 - 48) * 10L + (long)(b1 - 48);
            }
            case 3: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57) break;
                return (long)(b0 - 48) * 100L + (long)((b1 - 48) * 10) + (long)(b2 - 48);
            }
            case 4: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57) break;
                return (long)(b0 - 48) * 1000L + (long)((b1 - 48) * 100) + (long)((b2 - 48) * 10) + (long)(b3 - 48);
            }
            case 5: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57) break;
                return (long)(b0 - 48) * 10000L + (long)((b1 - 48) * 1000) + (long)((b2 - 48) * 100) + (long)((b3 - 48) * 10) + (long)(b4 - 48);
            }
            case 6: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57) break;
                return (long)(b0 - 48) * 100000L + (long)((b1 - 48) * 10000) + (long)((b2 - 48) * 1000) + (long)((b3 - 48) * 100) + (long)((b4 - 48) * 10) + (long)(b5 - 48);
            }
            case 7: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57) break;
                return (long)(b0 - 48) * 1000000L + (long)((b1 - 48) * 100000) + (long)((b2 - 48) * 10000) + (long)((b3 - 48) * 1000) + (long)((b4 - 48) * 100) + (long)((b5 - 48) * 10) + (long)(b6 - 48);
            }
            case 8: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                byte b7 = bytes[off + 7];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57 || b7 < 48 || b7 > 57) break;
                return (long)(b0 - 48) * 10000000L + (long)((b1 - 48) * 1000000) + (long)((b2 - 48) * 100000) + (long)((b3 - 48) * 10000) + (long)((b4 - 48) * 1000) + (long)((b5 - 48) * 100) + (long)((b6 - 48) * 10) + (long)(b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Long.parseLong(str);
    }

    public static BigDecimal parseBigDecimal(byte[] bytes, int off, int len) {
        if (len == 0) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)bytes[off + i];
        }
        return new BigDecimal(chars, 0, chars.length);
    }

    public static Integer toInteger(Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        if (value instanceof Map && ((Map)value).isEmpty()) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new JSONException("can not cast to integer");
    }

    public static Byte toByte(Object value) {
        if (value == null || value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static byte toByteValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static Short toShort(Object value) {
        if (value == null || value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static short toShortValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return (byte)((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static int toIntValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            if (str.indexOf(46) != -1) {
                return new BigDecimal(str).intValueExact();
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static boolean toBooleanValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return false;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static float toFloatValue(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Float toFloat(Object value) {
        if (value == null || value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("can not cast to decimal");
    }

    public static double toDoubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Double toDouble(Object value) {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static int compare(Object a, Object b) {
        if (a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        Class<?> typeA = a.getClass();
        Class<?> typeB = b.getClass();
        if (typeA == BigDecimal.class) {
            if (typeB == Integer.class) {
                b = new BigDecimal((Integer)b);
            } else if (typeB == Long.class) {
                b = new BigDecimal((Long)b);
            } else if (typeB == Float.class) {
                b = new BigDecimal(((Float)b).floatValue());
            } else if (typeB == Double.class) {
                b = new BigDecimal((Double)b);
            } else if (typeB == BigInteger.class) {
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == BigInteger.class) {
            if (typeB == Integer.class) {
                b = BigInteger.valueOf(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = BigInteger.valueOf((Long)b);
            } else if (typeB == Float.class) {
                b = new BigDecimal(((Float)b).floatValue());
                a = new BigDecimal((BigInteger)a);
            } else if (typeB == Double.class) {
                b = new BigDecimal((Double)b);
                a = new BigDecimal((BigInteger)a);
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((BigInteger)a);
            }
        } else if (typeA == Long.class) {
            if (typeB == Integer.class) {
                b = new Long(((Integer)b).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Long)a);
            } else if (typeB == Float.class) {
                a = new Float(((Long)a).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Long)a).longValue());
            } else if (typeB == BigInteger.class) {
                a = BigInteger.valueOf((Long)a);
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf((Long)a);
                b = new BigDecimal((String)b);
            }
        } else if (typeA == Integer.class) {
            if (typeB == Long.class) {
                a = new Long(((Integer)a).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Integer)a);
            } else if (typeB == BigInteger.class) {
                a = BigInteger.valueOf(((Integer)a).intValue());
            } else if (typeB == Float.class) {
                a = new Float(((Integer)a).intValue());
            } else if (typeB == Double.class) {
                a = new Double(((Integer)a).intValue());
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf(((Integer)a).intValue());
                b = new BigDecimal((String)b);
            }
        } else if (typeA == Double.class) {
            if (typeB == Integer.class) {
                b = new Double(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Double(((Long)b).longValue());
            } else if (typeB == Float.class) {
                b = new Double(((Float)b).floatValue());
            } else if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf((Double)a);
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == Float.class) {
            if (typeB == Integer.class) {
                b = new Float(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Float(((Long)b).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Float)a).floatValue());
            } else if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == String.class) {
            String strA = (String)a;
            if (typeB == Integer.class) {
                NumberFormatException error = null;
                try {
                    a = Integer.parseInt(strA);
                }
                catch (NumberFormatException ex) {
                    error = ex;
                }
                if (error != null) {
                    try {
                        a = Long.parseLong(strA);
                        b = (long)((Integer)b).intValue();
                        error = null;
                    }
                    catch (NumberFormatException ex) {
                        error = ex;
                    }
                }
                if (error != null) {
                    a = new BigDecimal(strA);
                    b = BigDecimal.valueOf(((Integer)b).intValue());
                }
            } else if (typeB == Long.class) {
                a = new BigDecimal(strA);
                b = BigDecimal.valueOf((Long)b);
            } else if (typeB == Float.class) {
                a = Float.valueOf(Float.parseFloat(strA));
            } else if (typeB == Double.class) {
                a = Double.parseDouble(strA);
            } else if (typeB == BigInteger.class) {
                a = new BigInteger(strA);
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal(strA);
            }
        }
        return ((Comparable)a).compareTo(b);
    }

    public static Object getDefaultValue(Type paramType) {
        if (paramType == Integer.TYPE) {
            return 0;
        }
        if (paramType == Long.TYPE) {
            return 0L;
        }
        if (paramType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (paramType == Double.TYPE) {
            return 0.0;
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramType == Short.TYPE) {
            return (short)0;
        }
        if (paramType == Byte.TYPE) {
            return (byte)0;
        }
        if (paramType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (paramType == Optional.class) {
            return Optional.empty();
        }
        if (paramType == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (paramType == OptionalLong.class) {
            return OptionalLong.empty();
        }
        if (paramType == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        return null;
    }

    public static Class loadClass(String className) {
        if (className.length() >= 192) {
            return null;
        }
        switch (className) {
            case "O": 
            case "Object": 
            case "java.lang.Object": {
                return Object.class;
            }
            case "java.util.Collections$EmptyMap": {
                return Collections.EMPTY_MAP.getClass();
            }
            case "java.util.Collections$EmptyList": {
                return Collections.EMPTY_LIST.getClass();
            }
            case "java.util.Collections$EmptySet": {
                return Collections.EMPTY_SET.getClass();
            }
            case "java.util.Optional": {
                return Optional.class;
            }
            case "java.util.OptionalInt": {
                return OptionalInt.class;
            }
            case "java.util.OptionalLong": {
                return OptionalLong.class;
            }
            case "List": 
            case "java.util.List": {
                return List.class;
            }
            case "A": 
            case "ArrayList": 
            case "java.util.ArrayList": {
                return ArrayList.class;
            }
            case "LA": 
            case "LinkedList": 
            case "java.util.LinkedList": {
                return LinkedList.class;
            }
            case "Map": 
            case "java.util.Map": {
                return Map.class;
            }
            case "M": 
            case "HashMap": 
            case "java.util.HashMap": {
                return HashMap.class;
            }
            case "LM": 
            case "LinkedHashMap": 
            case "java.util.LinkedHashMap": {
                return LinkedHashMap.class;
            }
            case "ConcurrentHashMap": {
                return ConcurrentHashMap.class;
            }
            case "ConcurrentLinkedQueue": {
                return ConcurrentLinkedQueue.class;
            }
            case "ConcurrentLinkedDeque": {
                return ConcurrentLinkedDeque.class;
            }
            case "JSONObject": {
                return JSONObject.class;
            }
            case "JO1": {
                className = "com.alibaba.fastjson.JSONObject";
                break;
            }
            case "Set": 
            case "java.util.Set": {
                return Set.class;
            }
            case "HashSet": 
            case "java.util.HashSet": {
                return HashSet.class;
            }
            case "LinkedHashSet": 
            case "java.util.LinkedHashSet": {
                return LinkedHashSet.class;
            }
            case "TreeSet": 
            case "java.util.TreeSet": {
                return TreeSet.class;
            }
            case "java.lang.Class": {
                return Class.class;
            }
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "java.lang.Long": {
                return Long.class;
            }
            case "String": 
            case "java.lang.String": {
                return String.class;
            }
            case "[String": {
                return String[].class;
            }
            case "I": 
            case "int": {
                return Integer.TYPE;
            }
            case "S": 
            case "short": {
                return Short.TYPE;
            }
            case "J": 
            case "long": {
                return Long.TYPE;
            }
            case "Z": 
            case "boolean": {
                return Boolean.TYPE;
            }
            case "B": 
            case "byte": {
                return Byte.TYPE;
            }
            case "F": 
            case "float": {
                return Float.TYPE;
            }
            case "D": 
            case "double": {
                return Double.TYPE;
            }
            case "C": 
            case "char": {
                return Character.TYPE;
            }
            case "[B": 
            case "byte[]": {
                return byte[].class;
            }
            case "[S": 
            case "short[]": {
                return short[].class;
            }
            case "[I": 
            case "int[]": {
                return int[].class;
            }
            case "[J": 
            case "long[]": {
                return long[].class;
            }
            case "[F": 
            case "float[]": {
                return float[].class;
            }
            case "[D": 
            case "double[]": {
                return double[].class;
            }
            case "[C": 
            case "char[]": {
                return char[].class;
            }
            case "[Z": 
            case "boolean[]": {
                return boolean[].class;
            }
            case "[O": {
                return Object[].class;
            }
            case "UUID": {
                return UUID.class;
            }
            case "Date": {
                return Date.class;
            }
            case "Calendar": {
                return Calendar.class;
            }
            case "java.io.IOException": {
                return IOException.class;
            }
            case "java.util.Collections$UnmodifiableRandomAccessList": {
                return CLASS_UNMODIFIABLE_LIST;
            }
            case "java.util.Arrays$ArrayList": {
                return Arrays.asList(1).getClass();
            }
            case "java.util.Collections$SingletonList": {
                return CLASS_SINGLE_List;
            }
            case "java.util.Collections$SingletonSet": {
                return CLASS_SINGLE_SET;
            }
        }
        Class mapping = TYPE_MAPPINGS.get(className);
        if (mapping != null) {
            return mapping;
        }
        if (className.startsWith("java.util.ImmutableCollections$")) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return CLASS_UNMODIFIABLE_LIST;
            }
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            className = className.substring(1, className.length() - 1);
        }
        if (className.charAt(0) == '[' || className.endsWith("[]")) {
            String itemClassName = className.charAt(0) == '[' ? className.substring(1) : className.substring(0, className.length() - 2);
            Class itemClass = TypeUtils.loadClass(itemClassName);
            if (itemClass == null) {
                throw new JSONException("load class error " + className);
            }
            return Array.newInstance(itemClass, 0).getClass();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return JSON.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static Class<?> getArrayClass(Class componentClass) {
        if (componentClass == Integer.TYPE) {
            return int[].class;
        }
        if (componentClass == Byte.TYPE) {
            return byte[].class;
        }
        if (componentClass == Short.TYPE) {
            return short[].class;
        }
        if (componentClass == Long.TYPE) {
            return long[].class;
        }
        if (componentClass == String.class) {
            return String[].class;
        }
        if (componentClass == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(componentClass, 1).getClass();
    }

    public static Class<?> getClass(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getClass(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(upperBounds[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            Class<?> componentClass = TypeUtils.getClass(componentType);
            return TypeUtils.getArrayClass(componentClass);
        }
        return Object.class;
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> item : clazz.getInterfaces()) {
            String interfaceName;
            switch (interfaceName = item.getName()) {
                case "org.springframework.cglib.proxy.Factory": 
                case "javassist.util.proxy.ProxyObject": 
                case "org.apache.ibatis.javassist.util.proxy.ProxyObject": 
                case "org.hibernate.proxy.HibernateProxy": 
                case "org.springframework.context.annotation.ConfigurationClassEnhancer$EnhancedConfiguration": 
                case "org.mockito.cglib.proxy.Factory": 
                case "net.sf.cglib.proxy.Factory": {
                    return true;
                }
            }
        }
        return false;
    }

    public static Map getInnerMap(Map object) {
        if (object == null || CLASS_JSON_OBJECT_1x == null || !CLASS_JSON_OBJECT_1x.isInstance(object) || FIELD_JSON_OBJECT_1x_map == null) {
            return object;
        }
        try {
            object = (Map)FIELD_JSON_OBJECT_1x_map.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        Class[] classes;
        CLASS_SINGLE_SET = Collections.singleton(1).getClass();
        CLASS_SINGLE_List = Collections.singletonList(1).getClass();
        CLASS_UNMODIFIABLE_COLLECTION = Collections.unmodifiableCollection(new ArrayList()).getClass();
        CLASS_UNMODIFIABLE_LIST = Collections.unmodifiableList(new ArrayList()).getClass();
        CLASS_UNMODIFIABLE_SET = Collections.unmodifiableSet(new HashSet()).getClass();
        CLASS_UNMODIFIABLE_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet()).getClass();
        CLASS_UNMODIFIABLE_NAVIGABLE_SET = Collections.unmodifiableNavigableSet(new TreeSet()).getClass();
        PARAM_TYPE_LIST_STR = new ParameterizedTypeImpl((Type)((Object)List.class), new Type[]{String.class});
        CACHE = new Cache();
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
        NAME_MAPPINGS = new IdentityHashMap<Class, String>();
        TYPE_MAPPINGS = new ConcurrentHashMap<String, Class>();
        CLASS_JSON_OBJECT_1x = TypeUtils.loadClass("com.alibaba.fastjson.JSONObject");
        Field field = null;
        if (CLASS_JSON_OBJECT_1x != null) {
            try {
                field = CLASS_JSON_OBJECT_1x.getDeclaredField("map");
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        FIELD_JSON_OBJECT_1x_map = field;
        CLASS_JSON_ARRAY_1x = TypeUtils.loadClass("com.alibaba.fastjson.JSONArray");
        NAME_MAPPINGS.put(Byte.TYPE, "B");
        NAME_MAPPINGS.put(Short.TYPE, "S");
        NAME_MAPPINGS.put(Integer.TYPE, "I");
        NAME_MAPPINGS.put(Long.TYPE, "J");
        NAME_MAPPINGS.put(Float.TYPE, "F");
        NAME_MAPPINGS.put(Double.TYPE, "D");
        NAME_MAPPINGS.put(Character.TYPE, "C");
        NAME_MAPPINGS.put(Boolean.TYPE, "Z");
        NAME_MAPPINGS.put(Object[].class, "[O");
        NAME_MAPPINGS.put(Object[][].class, "[[O");
        NAME_MAPPINGS.put(byte[].class, "[B");
        NAME_MAPPINGS.put(byte[][].class, "[[B");
        NAME_MAPPINGS.put(short[].class, "[S");
        NAME_MAPPINGS.put(short[][].class, "[[S");
        NAME_MAPPINGS.put(int[].class, "[I");
        NAME_MAPPINGS.put(int[][].class, "[[I");
        NAME_MAPPINGS.put(long[].class, "[J");
        NAME_MAPPINGS.put(long[][].class, "[[J");
        NAME_MAPPINGS.put(float[].class, "[F");
        NAME_MAPPINGS.put(float[][].class, "[[F");
        NAME_MAPPINGS.put(double[].class, "[D");
        NAME_MAPPINGS.put(double[][].class, "[[D");
        NAME_MAPPINGS.put(char[].class, "[C");
        NAME_MAPPINGS.put(char[][].class, "[[C");
        NAME_MAPPINGS.put(boolean[].class, "[Z");
        NAME_MAPPINGS.put(boolean[][].class, "[[Z");
        NAME_MAPPINGS.put(Byte[].class, "[Byte");
        NAME_MAPPINGS.put(Byte[][].class, "[[Byte");
        NAME_MAPPINGS.put(Short[].class, "[Short");
        NAME_MAPPINGS.put(Short[][].class, "[[Short");
        NAME_MAPPINGS.put(Integer[].class, "[Integer");
        NAME_MAPPINGS.put(Integer[][].class, "[[Integer");
        NAME_MAPPINGS.put(Long[].class, "[Long");
        NAME_MAPPINGS.put(Long[][].class, "[[Long");
        NAME_MAPPINGS.put(Float[].class, "[Float");
        NAME_MAPPINGS.put(Float[][].class, "[[Float");
        NAME_MAPPINGS.put(Double[].class, "[Double");
        NAME_MAPPINGS.put(Double[][].class, "[[Double");
        NAME_MAPPINGS.put(Character[].class, "[Character");
        NAME_MAPPINGS.put(Character[][].class, "[[Character");
        NAME_MAPPINGS.put(Boolean[].class, "[Boolean");
        NAME_MAPPINGS.put(Boolean[][].class, "[[Boolean");
        NAME_MAPPINGS.put(String[].class, "[String");
        NAME_MAPPINGS.put(String[][].class, "[[String");
        NAME_MAPPINGS.put(BigDecimal[].class, "[BigDecimal");
        NAME_MAPPINGS.put(BigDecimal[][].class, "[[BigDecimal");
        NAME_MAPPINGS.put(BigInteger[].class, "[BigInteger");
        NAME_MAPPINGS.put(BigInteger[][].class, "[[BigInteger");
        NAME_MAPPINGS.put(UUID[].class, "[UUID");
        NAME_MAPPINGS.put(UUID[][].class, "[[UUID");
        NAME_MAPPINGS.put(Object.class, "Object");
        NAME_MAPPINGS.put(Object[].class, "[O");
        NAME_MAPPINGS.put(HashMap.class, "M");
        TYPE_MAPPINGS.put("HashMap", HashMap.class);
        TYPE_MAPPINGS.put("java.util.HashMap", HashMap.class);
        NAME_MAPPINGS.put(LinkedHashMap.class, "LM");
        TYPE_MAPPINGS.put("LinkedHashMap", LinkedHashMap.class);
        TYPE_MAPPINGS.put("java.util.LinkedHashMap", LinkedHashMap.class);
        NAME_MAPPINGS.put(TreeMap.class, "TM");
        TYPE_MAPPINGS.put("TreeMap", TreeMap.class);
        NAME_MAPPINGS.put(ArrayList.class, "A");
        TYPE_MAPPINGS.put("ArrayList", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ArrayList", ArrayList.class);
        NAME_MAPPINGS.put(LinkedList.class, "LA");
        TYPE_MAPPINGS.put("LA", LinkedList.class);
        TYPE_MAPPINGS.put("LinkedList", LinkedList.class);
        TYPE_MAPPINGS.put("java.util.LinkedList", LinkedList.class);
        TYPE_MAPPINGS.put("java.util.concurrent.ConcurrentLinkedQueue", ConcurrentLinkedQueue.class);
        TYPE_MAPPINGS.put("java.util.concurrent.ConcurrentLinkedDeque", ConcurrentLinkedDeque.class);
        NAME_MAPPINGS.put(HashSet.class, "HashSet");
        NAME_MAPPINGS.put(TreeSet.class, "TreeSet");
        NAME_MAPPINGS.put(LinkedHashSet.class, "LinkedHashSet");
        NAME_MAPPINGS.put(ConcurrentHashMap.class, "ConcurrentHashMap");
        NAME_MAPPINGS.put(ConcurrentLinkedQueue.class, "ConcurrentLinkedQueue");
        NAME_MAPPINGS.put(ConcurrentLinkedDeque.class, "ConcurrentLinkedDeque");
        NAME_MAPPINGS.put(JSONObject.class, "JSONObject");
        NAME_MAPPINGS.put(JSONArray.class, "JSONArray");
        NAME_MAPPINGS.put(Currency.class, "Currency");
        NAME_MAPPINGS.put(TimeUnit.class, "TimeUnit");
        Class[] classArray = classes = new Class[]{Object.class, Cloneable.class, AutoCloseable.class, Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, LinkedList.class, TimeUnit.class, ConcurrentHashMap.class, AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, BigDecimal.class, BigInteger.class, BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Currency.class, SimpleDateFormat.class, JSONObject.class, JSONArray.class, ConcurrentSkipListMap.class, ConcurrentSkipListSet.class};
        int n = classArray.length;
        boolean bl = false;
        while (var3_6 < n) {
            Class clazz = classArray[var3_6];
            TYPE_MAPPINGS.put(clazz.getSimpleName(), clazz);
            TYPE_MAPPINGS.put(clazz.getName(), clazz);
            NAME_MAPPINGS.put(clazz, clazz.getSimpleName());
            ++var3_6;
        }
        TYPE_MAPPINGS.put("JO10", JSONObject1O.class);
        TYPE_MAPPINGS.put("[O", Object[].class);
        TYPE_MAPPINGS.put("[Ljava.lang.Object;", Object[].class);
        TYPE_MAPPINGS.put("[java.lang.Object", Object[].class);
        TYPE_MAPPINGS.put("[Object", Object[].class);
        TYPE_MAPPINGS.put("StackTraceElement", StackTraceElement.class);
        TYPE_MAPPINGS.put("[StackTraceElement", StackTraceElement[].class);
        String[] items = new String[]{"java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableCollection"};
        for (String className : items) {
            Class clazz = TypeUtils.loadClass(className);
            TYPE_MAPPINGS.put(clazz.getName(), clazz);
        }
        if (CLASS_JSON_OBJECT_1x != null) {
            TYPE_MAPPINGS.putIfAbsent("JO1", CLASS_JSON_OBJECT_1x);
            TYPE_MAPPINGS.putIfAbsent(CLASS_JSON_OBJECT_1x.getName(), CLASS_JSON_OBJECT_1x);
        }
        if (CLASS_JSON_ARRAY_1x != null) {
            TYPE_MAPPINGS.putIfAbsent("JA1", CLASS_JSON_ARRAY_1x);
            TYPE_MAPPINGS.putIfAbsent(CLASS_JSON_ARRAY_1x.getName(), CLASS_JSON_ARRAY_1x);
        }
        NAME_MAPPINGS.put(new HashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new LinkedHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new TreeMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().keySet().getClass(), "Set");
        TYPE_MAPPINGS.put("Set", HashSet.class);
        NAME_MAPPINGS.put(new HashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new LinkedHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new TreeMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().values().getClass(), "List");
        TYPE_MAPPINGS.put("List", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$Map1", HashMap.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$MapN", LinkedHashMap.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$Set12", LinkedHashSet.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$SetN", LinkedHashSet.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$List12", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$ListN", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$SubList", ArrayList.class);
        for (Map.Entry entry : NAME_MAPPINGS.entrySet()) {
            TYPE_MAPPINGS.putIfAbsent((String)entry.getValue(), (Class)entry.getKey());
        }
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

