/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTypedMulti;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;

final class JSONPathTypedMultiIndexes
extends JSONPathTypedMulti {
    final JSONPath prefix;
    final JSONPath[] indexPaths;
    final int[] indexes;
    final int maxIndex;

    JSONPathTypedMultiIndexes(JSONPath[] paths, JSONPath prefix, JSONPath[] indexPaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, types, formats, pathFeatures, zoneId, features);
        this.prefix = prefix;
        this.indexPaths = indexPaths;
        int[] indexes = new int[paths.length];
        for (int i = 0; i < indexPaths.length; ++i) {
            JSONPathSingleIndex indexPath = (JSONPathSingleIndex)indexPaths[i];
            indexes[i] = indexPath.index;
        }
        this.indexes = indexes;
        this.maxIndex = Arrays.stream(indexes).max().getAsInt();
    }

    @Override
    public Object eval(Object root) {
        Object[] array = new Object[this.paths.length];
        Object object = root;
        if (this.prefix != null) {
            object = this.prefix.eval(root);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < this.indexes.length; ++i) {
                Object result = list.get(this.indexes[i]);
                Type type = this.types[i];
                try {
                    if (result != null && result.getClass() != type) {
                        result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                    }
                    array[i] = result;
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreError(i)) continue;
                    throw new JSONException("jsonpath eval path, path : " + this.paths[i] + ", msg : " + e.getMessage(), e);
                }
            }
        } else {
            for (int i = 0; i < this.paths.length; ++i) {
                JSONPath jsonPath = this.indexPaths[i];
                Type type = this.types[i];
                try {
                    Object result = jsonPath.eval(object);
                    if (result != null && result.getClass() != type) {
                        result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                    }
                    array[i] = result;
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreError(i)) continue;
                    throw new JSONException("jsonpath eval path, path : " + this.paths[i] + ", msg : " + e.getMessage(), e);
                }
            }
        }
        return array;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        int i;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        if (this.prefix instanceof JSONPathSingleName) {
            JSONPathSingleName prefixName = (JSONPathSingleName)this.prefix;
            long prefixNameHash = prefixName.nameHashCode;
            if (!jsonReader.nextIfObjectStart()) {
                throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
            }
            while (!jsonReader.nextIfObjectEnd()) {
                boolean match;
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == prefixNameHash;
                if (match || jsonReader.isObject() || jsonReader.isArray()) break;
                jsonReader.skipValue();
            }
            if (jsonReader.nextIfNull()) {
                return null;
            }
        } else if (this.prefix instanceof JSONPathSingleIndex) {
            int index = ((JSONPathSingleIndex)this.prefix).index;
            int max = jsonReader.startArray();
            for (i = 0; i < index && i < max; ++i) {
                jsonReader.skipValue();
            }
            if (jsonReader.nextIfNull()) {
                return null;
            }
        } else if (this.prefix != null) {
            Object object = jsonReader.readAny();
            return this.eval(object);
        }
        int max = jsonReader.startArray();
        Object[] array = new Object[this.indexes.length];
        for (i = 0; i <= this.maxIndex && i < max; ++i) {
            Integer index = null;
            for (int j = 0; j < this.indexes.length; ++j) {
                if (this.indexes[j] != i) continue;
                index = j;
                break;
            }
            if (index == null) {
                jsonReader.skipValue();
                continue;
            }
            Type type = this.types[index];
            array[index.intValue()] = jsonReader.read(type);
        }
        return array;
    }
}

