/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class HttpClientInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof HttpHost && args[1] != null && args[1] instanceof HttpRequest) {
                Header[] envIdheaders;
                String hostUri = ((HttpHost)args[0]).toURI();
                HttpRequest httpRequest = (HttpRequest)args[1];
                String requestUri = httpRequest.getRequestLine().getUri();
                String httpMethod = "unkown";
                if (args[1] instanceof HttpUriRequest) {
                    httpMethod = ((HttpUriRequest)args[1]).getMethod();
                }
                if (!Boolean.TRUE.equals(ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get())) {
                    HttpClientCollector.onStart((String)hostUri, (String)requestUri, (String)httpMethod, (String)HttpClientType.Httpclient4.name());
                }
                if ((envIdheaders = httpRequest.getHeaders(Headers.ENV_ID.getValue())) != null && envIdheaders.length > 0) {
                    httpRequest.removeHeaders(Headers.ENV_ID.getValue());
                }
                httpRequest.addHeader(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
                Header[] domainIdheaders = httpRequest.getHeaders(Headers.DOMAIN_ID.getValue());
                if (domainIdheaders != null && domainIdheaders.length > 0) {
                    httpRequest.removeHeaders(Headers.DOMAIN_ID.getValue());
                }
                httpRequest.addHeader(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
                Header[] domainTypeheaders = httpRequest.getHeaders(Headers.DOMAIN_TYPE.getValue());
                if (domainTypeheaders != null && domainTypeheaders.length > 0) {
                    httpRequest.removeHeaders(Headers.DOMAIN_TYPE.getValue());
                }
                httpRequest.addHeader(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
                this.setHeaders(className, methodName, requestUri, httpMethod, httpRequest);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    private void setHeaders(String className, String methodName, String requestUri, String httpMethod, HttpRequest httpRequest) {
        List txName;
        String userFlag;
        String gTraceId;
        SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Httpclient4.name());
        if (spanEvent != null) {
            this.collectRequestBody(httpRequest);
            spanEvent.addTag("url", requestUri);
            spanEvent.addTag("httpMethod", httpMethod);
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            Header[] traceIdheaders = httpRequest.getHeaders(Headers.TRACE_ID.getValue());
            if (traceIdheaders != null && traceIdheaders.length > 0) {
                httpRequest.removeHeaders(Headers.TRACE_ID.getValue());
                httpRequest.removeHeaders(Headers.SPAN_ID.getValue());
                httpRequest.removeHeaders(Headers.SOURCE_EVENT_ID.getValue());
            }
            httpRequest.addHeader(Headers.TRACE_ID.getValue(), traceId);
            httpRequest.addHeader(Headers.SPAN_ID.getValue(), nextSpanId);
            httpRequest.addHeader(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            httpRequest.addHeader(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
            httpRequest.addHeader(Headers.USER_FLAG.getValue(), userFlag);
        }
        if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
            httpRequest.addHeader(Headers.TXNANE_ID.getValue(), StringUtils.joinTxList((CharSequence)",", (List)txName));
        }
    }

    private void collectRequestBody(HttpRequest httpRequest) {
        try {
            HttpEntity httpEntity;
            if (httpRequest instanceof HttpEntityEnclosingRequestBase && AgentConfigManager.isCollectHttpClientBody() && !(httpEntity = ((HttpEntityEnclosingRequestBase)httpRequest).getEntity()).isStreaming()) {
                TraceCollector.addTag((String)"requestBody", (String)EntityUtils.toString((HttpEntity)httpEntity), (int)AgentConfigManager.getCollectBodyLength());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                if (!Boolean.TRUE.equals(ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get())) {
                    HttpClientCollector.onThrowable((Throwable)e);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof HttpHost && args[1] != null && args[1] instanceof HttpRequest) {
                String envId = null;
                if (result != null && result instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)result;
                    this.collectResponseBody(httpResponse);
                    StatusLine st = httpResponse.getStatusLine();
                    Header[] httpResponseheaders = httpResponse.getHeaders(Headers.ENV_ID.getValue());
                    if (httpResponseheaders.length > 0) {
                        envId = httpResponseheaders[0].getValue();
                    }
                    if (st != null) {
                        int code = st.getStatusCode();
                        if (!Boolean.TRUE.equals(ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get())) {
                            HttpClientCollector.onStatusCode((String)((HttpRequest)args[1]).getRequestLine().getUri(), (int)code);
                        }
                        TraceCollector.addTag((String)"code", (String)String.valueOf(code));
                    }
                }
                TraceCollector.onFinally();
                if (!Boolean.TRUE.equals(ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.get())) {
                    HttpClientCollector.onResponseClose(envId);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    private void collectResponseBody(HttpResponse result) {
        try {
            if (AgentConfigManager.isCollectHttpClientBody()) {
                String requestBody;
                SpanEvent spanEvent;
                HttpEntity httpEntity = result.getEntity();
                if (httpEntity != null && !httpEntity.isStreaming()) {
                    TraceCollector.addTag((String)"responseBody", (String)EntityUtils.toString((HttpEntity)httpEntity), (int)AgentConfigManager.getCollectBodyLength());
                } else if (httpEntity instanceof TransformAccess && (spanEvent = TraceCollector.getSpanEvent()) != null && (requestBody = (String)spanEvent.getTags().get("requestBody")) != null) {
                    ((TransformAccess)httpEntity).setLopsAttribute((Object)requestBody);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

