/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import org.apache.http.HttpEntity;

public class EntityUtilInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        HttpEntity httpEntity;
        if (HttpClientCollector.INSTANCE.isEnable() && AgentConfigManager.isCollectHttpClientBody() && (httpEntity = (HttpEntity)args[0]) != null && httpEntity.isStreaming()) {
            TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Httpclient4.name());
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (HttpClientCollector.INSTANCE.isEnable() && AgentConfigManager.isCollectHttpClientBody()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        HttpEntity httpEntity;
        if (HttpClientCollector.INSTANCE.isEnable() && AgentConfigManager.isCollectHttpClientBody() && (httpEntity = (HttpEntity)args[0]) != null && httpEntity.isStreaming()) {
            String requestBody;
            if (httpEntity instanceof TransformAccess && (requestBody = (String)((TransformAccess)httpEntity).getLopsAttribute()) != null) {
                TraceCollector.addTag((String)"requestBody", (String)requestBody, (int)AgentConfigManager.getCollectBodyLength());
            }
            TraceCollector.addTag((String)"responseBody", (String)String.valueOf(result), (int)AgentConfigManager.getCollectBodyLength());
            TraceCollector.onFinally();
        }
    }
}

