/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PoolObjectHolder;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;

public class NioConnectionPoolAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public String getName() {
        return "connectionPool";
    }

    private MonitorDataRow buildRow(Object obj) {
        if (obj instanceof PoolingNHttpClientConnectionManager && obj instanceof TransformAccess) {
            MonitorDataRow row = new MonitorDataRow();
            Integer poolId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)obj, (String)"poolId");
            if (poolId != null) {
                PoolStats nioPoolStats = ((PoolingNHttpClientConnectionManager)obj).getTotalStats();
                row.put((Object)"poolId", (Object)String.valueOf(poolId));
                row.put((Object)"leased", (Object)nioPoolStats.getLeased());
                row.put((Object)"pending", (Object)nioPoolStats.getPending());
                row.put((Object)"available", (Object)nioPoolStats.getAvailable());
                row.put((Object)"max", (Object)nioPoolStats.getMax());
                return row;
            }
        }
        return null;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String nioKey = primaryKeyMap.get("poolId");
        if (nioKey == null) {
            return null;
        }
        CopyOnWriteArrayList nioPoolList = PoolObjectHolder.getPoolList();
        for (Object o : nioPoolList) {
            MonitorDataRow nioRow = this.buildRow(o);
            if (nioRow == null || !nioKey.equals(nioRow.get((Object)"poolId"))) continue;
            return nioRow;
        }
        return null;
    }

    public void clear() {
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> nioResult = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList nioPoolList = PoolObjectHolder.getPoolList();
        for (Object o : nioPoolList) {
            MonitorDataRow row = this.buildRow(o);
            if (row == null) continue;
            nioResult.add(row);
        }
        return nioResult;
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

