/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.httpasyncclient.collector.NioConnectionStats;
import java.util.HashMap;
import java.util.Map;

public class NioConnectionAggregator
extends SinglePrimaryKeyAggregator<NioConnectionStats> {
    private int timeSpanThreshold = 1;
    private boolean getPoolInfo = false;
    private static final String TIME_SPAN_THRESHOLD = "TimeSpanThreshold";
    private static final String GET_POOL_INFO = "GetPoolInfo";
    private static final String ROUTE = "route";

    public void parseParameters(Map<String, String> parameters) {
        Integer timeSpanThreshold = ParameterParseUtil.getInteger(parameters, (String)TIME_SPAN_THRESHOLD);
        Boolean getPoolInfo = ParameterParseUtil.getBoolean(parameters, (String)GET_POOL_INFO);
        if (timeSpanThreshold != null) {
            this.timeSpanThreshold = timeSpanThreshold;
        }
        if (getPoolInfo != null) {
            this.getPoolInfo = getPoolInfo;
        }
    }

    public Map<String, Object> onStart(String route) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        NioConnectionStats stats = (NioConnectionStats)this.getValue(route);
        long startTime = stats.onStart();
        map.put("stats", (Object)stats);
        map.put("startTime", startTime);
        return map;
    }

    public void onError(NioConnectionStats stats) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.incrementErrorCount();
        }
    }

    public void onFinally(Long startTime, NioConnectionStats stats) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null && startTime != null) {
            stats.onFinally(startTime);
        }
    }

    public int getTimeSpanThreshold() {
        return this.timeSpanThreshold;
    }

    public boolean isGetPoolInfo() {
        return this.getPoolInfo;
    }

    protected Class<NioConnectionStats> getValueType() {
        return NioConnectionStats.class;
    }

    public String getName() {
        return "connection";
    }

    protected String primaryKey() {
        return ROUTE;
    }
}

