/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.redis.collector.commons.RedisModeEnum;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientInfoAggregator
extends NonePrimaryKeyAggregator {
    private static final String STATICTICS_KEY_CLIENT_VERSION = "clientInfo";
    private static final String STATICTICS_KEY_VERSION = "version";
    private static final String STATICTICS_KEY_MODE = "mode";
    private static final String STATICTICS_KEY_CURRENT_NODES = "nodes";
    private String clientVersion;
    private RedisModeEnum mode = RedisModeEnum.STANDALONE;
    private List<String> clusterNodes = new ArrayList<String>();

    public MonitorDataRow constructItemRow() {
        return new MonitorDataRow().add(STATICTICS_KEY_VERSION, (Object)this.clientVersion).add(STATICTICS_KEY_MODE, (Object)this.mode.getCode()).add(STATICTICS_KEY_CURRENT_NODES, (Object)RedisTransformHelper.normalizeList(this.clusterNodes));
    }

    public void setClientVersion(String jedisVersion) {
        this.clientVersion = jedisVersion;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public String getName() {
        return STATICTICS_KEY_CLIENT_VERSION;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }

    public List<String> getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(List<String> clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public RedisModeEnum getMode() {
        return this.mode;
    }

    public void setMode(RedisModeEnum mode) {
        this.mode = mode;
    }
}

