/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.jedis.collector.GenericObjectPoolStats;
import com.lubanops.apm.plugin.jedis.collector.JedisCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class JedisClusterPoolAggregator
extends AbstractAggregator {
    private static final int MAX_SIZE = 512;
    private static final String JEDIS_AGGREGATE_KEY_POOL_ID = "pool";
    private ConcurrentMap<String, GenericObjectPoolStats> valueStats = new ConcurrentHashMap<String, GenericObjectPoolStats>(16);

    public String getName() {
        return "jedisPool";
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public void register(String poolId, GenericObjectPool pool) {
        if (this.valueStats.size() < 512) {
            this.valueStats.putIfAbsent(poolId, new GenericObjectPoolStats());
            ((GenericObjectPoolStats)this.valueStats.get(poolId)).bind(pool);
        }
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        MonitorDataRow dataRow = null;
        String poolId = primaryKeyMap.get(JEDIS_AGGREGATE_KEY_POOL_ID);
        if (StringUtils.isBlank((String)poolId)) {
            return dataRow;
        }
        GenericObjectPoolStats poolStats = (GenericObjectPoolStats)this.valueStats.get(poolId);
        return poolStats.harvest();
    }

    public List<MonitorDataRow> getAllStatus() {
        return this.harvest();
    }

    public List<MonitorDataRow> harvest() {
        if (!JedisCollector.getInstance().isEnable()) {
            return null;
        }
        ArrayList<MonitorDataRow> poolList = new ArrayList<MonitorDataRow>();
        for (Map.Entry entry : this.valueStats.entrySet()) {
            MonitorDataRow dataRow = ((GenericObjectPoolStats)entry.getValue()).harvest();
            dataRow.put((Object)JEDIS_AGGREGATE_KEY_POOL_ID, entry.getKey());
            poolList.add(dataRow);
        }
        return poolList;
    }

    public void clear() {
        this.setFull(false);
        this.setFullOutputted(false);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }
}

