/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;

public class GetInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                HTable table = (HTable)object;
                String tableNameWithNamespace = HBaseUtils.getTableNameWithNamespace(table);
                Get get = (Get)args[0];
                String parsedGet = HBaseUtils.parseGet(get);
                HBaseCollector.onStart(tableNameWithNamespace, parsedGet);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                if (spanEvent != null) {
                    spanEvent.addTag("Table Name", tableNameWithNamespace);
                    spanEvent.addTag("Command", parsedGet);
                }
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HBaseCollector.onRequestError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                if (result != null && !((Result)result).isEmpty()) {
                    HBaseCollector.incrementQueryRowCount(1L);
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    if (spanEvent != null) {
                        spanEvent.addTag("Rows Queried", "1");
                    }
                }
                HBaseCollector.onFinally();
                TraceCollector.onFinally();
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
    }
}

