/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.clickhouse.ClickHouseContext;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseCollector;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class ConnectionInitInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            ClickHouseConnectionImpl connection = (ClickHouseConnectionImpl)object;
            ClickHouseProperties properties = (ClickHouseProperties)((AttributeAccess)connection).getLopsFileds()[0];
            String clickhouseDbName = Helper.getDbName((String)properties.getHost(), (int)properties.getPort(), (String)properties.getDatabase());
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(clickhouseDbName);
            TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"id", (Object)id);
            ClickHouseCollector.onConnectionCreated(id);
            String clusterUrls = ClickHouseContext.clusterUrlsLocal.get();
            if (clusterUrls != null) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"urls", (Object)clusterUrls);
            }
            if (ClickHouseCollector.INSTANCE.isEnable()) {
                ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.set(Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.remove();
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

