/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse;

import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlIdThreadLocal;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseCollector;

public class ClickHouseTrace {
    public static void onStart(String className, String methodName, String parsedSql, String originSql, Integer id) {
        SpanEvent spanEvent;
        if (ClickHouseCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"ClickHouse")) != null) {
            spanEvent.addTag("sql", parsedSql, ClickHouseCollector.CONFIG.getSqlSize());
            spanEvent.addTag("sqlId", (String)SqlIdThreadLocal.THREAD_LOCAL.get());
            if (ClickHouseCollector.CONFIG.isParseOriginSql()) {
                spanEvent.addTag("originSql", originSql, ClickHouseCollector.CONFIG.getSqlSize());
            }
            if (id != null) {
                String dBName = Helper.CONNECTION_TARGET_MAP.getResource(id.intValue());
                spanEvent.addTag("DBName", dBName);
            }
        }
    }

    public static void onError(Throwable e) {
        if (ClickHouseCollector.INSTANCE.isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public static void onFinally(int updateRowCount, int readRowCount) {
        if (ClickHouseCollector.INSTANCE.isEnable()) {
            if (updateRowCount > 0) {
                TraceCollector.addTag((String)"updateRowCount", (String)String.valueOf(updateRowCount));
            }
            if (readRowCount > 0) {
                TraceCollector.addTag((String)"readRowCount", (String)String.valueOf(readRowCount));
            }
            TraceCollector.onFinally();
        }
    }
}

